% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_support.r
\name{timeval}
\alias{timeval}
\title{Get an Amiga timeval struct value from raw data}
\usage{
timeval(x)
}
\arguments{
\item{x}{a \code{vector} of \code{raw} data that need to be converted into
Amiga timeval structs.}
}
\value{
Returns a \code{numeric} \code{vector} of a timespan in seconds. It is
represented as an S3 AmigaTimeVal class.
}
\description{
Some Amiga applications use a timeval struct (see references) to represent a
time span in seconds. This function coerces raw data to such a numeric time span.
}
\details{
Timeval is a structure (struct) as specified in device/timer.h on the Amiga (see
references). It represents a timespan in seconds. This function retrieves the
numeric value from \code{raw} data. Amongst others, the timeval struct was used
in the system-configuration file (see \link{SysConfig}) to specify key repeat speed,
key repeat delay and mouse double click speed. Use \code{as.raw} for the inverse
of this function and get the original raw data.
}
\examples{
## First four raw values represent seconds, the latter four microseconds:
temp <- timeval(as.raw(c(0, 0, 0, 1, 0, 0, 0, 1)))
print(temp)

## You can use 'as.raw' to get the original raw data again:
as.raw(temp)
}
\references{
\url{http://amigadev.elowar.com/read/ADCD_2.1/Includes_and_Autodocs_2._guide/node0053.html}
}
\author{
Pepijn de Vries
}
