% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workbench_icon.r
\name{simpleAmigaIcon}
\alias{simpleAmigaIcon}
\title{Create simple AmigaIcon objects}
\usage{
simpleAmigaIcon(version = c("OS1.x", "OS2.x"), type = c("WBDISK",
  "WBDRAWER", "WBTOOL", "WBPROJECT", "WBGARBAGE", "WBDEVICE", "WBKICK",
  "WBAPPICON"), two.images = TRUE, back.fill = FALSE, ...)
}
\arguments{
\item{version}{A \code{character} string indicating the Amiga OS version
with which the icon should be compatible. "\code{OS2.x}" indicates
>=OS2.0 and "\code{OS1.x}" indicates <OS2.0.}

\item{type}{A \code{character} string indicating the type of object (file, disk, directory, etc.)
the icon should represent. See the `Usage' section for all posible options.}

\item{two.images}{A single \code{logical} value, indicating whether
the selected icon is depicted as a second image (in which case the
icon contains two images). The default value is \code{TRUE}.}

\item{back.fill}{A single \code{logical} value, indicating whether
the selected image of the icon should use the `back fill' mode (default).
If set to \code{FALSE} `complement' mode is used. Note that
back fill is not compatible when the icon holds two images. In the
`complement' mode, the image colours are inverted when selected.
In the `back fill' exterior first colour is not inverted.}

\item{...}{Reserverd for additional arguments. Currently ignored.}
}
\value{
Returns a simple S3 object of class \code{\link{AmigaIcon}}.
}
\description{
Graphical representation of files and directories (icons) are stored as
separate files (with the .info extension) on the Amiga. This function writes
\code{\link{AmigaIcon}} class objects to such files.
}
\details{
This function creates basic \code{\link{AmigaIcon}} objects which
can be modified afterwards. It uses simple generic images to represent
different types of files or directories.
}
\examples{
\dontrun{
## Create an AmigaIcon object using the default arguments:
icon <- simpleAmigaIcon()
}
}
\seealso{
Other AmigaIcon.operations: \code{\link{AmigaIcon}},
  \code{\link{rawToAmigaIcon}},
  \code{\link{read.AmigaIcon}},
  \code{\link{write.AmigaIcon}}

Other raw.operations: \code{\link{as.raw}},
  \code{\link{colourToAmigaRaw}}, \code{\link{packBitmap}},
  \code{\link{rawToAmigaIcon}},
  \code{\link{rawToHWSprite}}, \code{\link{rawToIFFChunk}},
  \code{\link{rawToSysConfig}}
}
\author{
Pepijn de Vries
}
