% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\docType{class}
\name{RawPop-class}
\alias{RawPop-class}
\alias{[,RawPop-method}
\alias{c,RawPop-method}
\alias{show,RawPop-method}
\title{Raw Population}
\usage{
\S4method{[}{RawPop}(x, i)

\S4method{c}{RawPop}(x, ...)

\S4method{show}{RawPop}(object)
}
\arguments{
\item{x}{a 'RawPop' object}

\item{i}{index of individuals}

\item{...}{additional 'RawPop' objects}

\item{object}{a 'RawPop' object}
}
\description{
The raw population class contains only genotype data.
}
\section{Methods (by generic)}{
\itemize{
\item \code{[}: Extract RawPop by index

\item \code{c}: Combine multiple RawPops

\item \code{show}: Show population summary
}}

\section{Slots}{

\describe{
\item{\code{nInd}}{number of individuals}

\item{\code{nChr}}{number of chromosomes}

\item{\code{ploidy}}{level of ploidy}

\item{\code{nLoci}}{number of loci per chromosome}

\item{\code{geno}}{list of nChr length containing chromosome genotypes.
Each element is a three dimensional array of raw values. 
The array dimensions are nLoci by ploidy by nInd.}
}}

