% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataMethods.R
\name{UnknownFuns}
\alias{UnknownFuns}
\alias{isUnknown}
\alias{isUnknown.default}
\alias{isUnknown.POSIXlt}
\alias{isUnknown.list}
\alias{isUnknown.data.frame}
\alias{isUnknown.matrix}
\alias{unknownToNA}
\alias{unknownToNA.default}
\alias{unknownToNA.factor}
\alias{unknownToNA.list}
\alias{unknownToNA.data.frame}
\alias{NAToUnknown}
\alias{NAToUnknown.default}
\alias{NAToUnknown.factor}
\alias{NAToUnknown.list}
\alias{NAToUnknown.data.frame}
\alias{.unknownList}
\title{Change given unknown value to NA and vice versa.}
\usage{
isUnknown(x, unknown=NA, \dots)

unknownToNA(x, unknown, warning=FALSE, \dots)

NAToUnknown(x, unknown, force=FALSE, call.=FALSE, \dots)

\method{isUnknown}{default}(x, unknown, ...)

\method{isUnknown}{POSIXlt}(x, unknown, ...)

\method{isUnknown}{list}(x, unknown, ...)

\method{isUnknown}{data.frame}(x, unknown, ...)

\method{isUnknown}{matrix}(x, unknown, ...)

unknownToNA(x, unknown, warning = FALSE, ...)

\method{unknownToNA}{default}(x, unknown, warning, ...)

\method{unknownToNA}{factor}(x, unknown, warning, ...)

\method{unknownToNA}{list}(x, unknown, warning, ...)

\method{unknownToNA}{data.frame}(x, unknown, warning, ...)

NAToUnknown(x, unknown, force = FALSE, call. = FALSE, ...)

\method{NAToUnknown}{default}(x, unknown, force, call., ...)

\method{NAToUnknown}{factor}(x, unknown, force, call., ...)

\method{NAToUnknown}{list}(x, unknown, force, call., ...)

\method{NAToUnknown}{data.frame}(x, unknown, force, call., ...)

.unknownList(x, unknown)
}
\arguments{
\item{x}{generic, object with unknown value(s)}

\item{unknown}{generic, value used instead of \code{NA}}

\item{...}{arguments pased to other methods (as.character for POSIXlt in case of isUnknown)}

\item{warning}{logical, issue warning if \code{x} already has \code{NA}}

\item{force}{logical, force to apply already existing value in \code{x}}

\item{call.}{logical, look in \code{\link{warning}}}
}
\description{
Unknown or missing values (\code{NA} in \code{R}) can be represented in various ways (as 0, 999, etc.) in different programs. \code{isUnknown}, \code{unknownToNA}, and \code{NAToUnknown} can help to change unknown values to \code{NA} and vice versa.
}
\seealso{
\code{\link[AlphaPart]{AlphaPart}}
}
\author{
Gregor Gorjanc
}
\keyword{internal}
