% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.summaryAlphaPart.R
\name{plot.summaryAlphaPart}
\alias{plot.summaryAlphaPart}
\title{plot.summaryAlphaPart.R}
\usage{
\method{plot}{summaryAlphaPart}(x, sortValue = TRUE,
  sortValueFUN = sum, sortValueDec = TRUE, addSum = TRUE,
  paths = NULL, xlab = NULL, ylab = NULL, xlim = NULL,
  ylim = NULL, ylimRel = NULL, color, lineSize = 1, lineType = 1,
  lineTypeList = NULL, useDirectLabels = TRUE, method = list(last.qp,
  hjust = 0), labelPath = NULL, ...)
}
\arguments{
\item{x}{summaryAlphaPart, object from the \code{AlphaPart(...)} or \code{summary(AlphaPart(...), ...)} call.}

\item{sortValue}{Logical, affect legend attributes via sort of paths according to
\code{sortValueFUN} function; if not logical, then ordered paths are given as a character vector.}

\item{sortValueFUN}{Function, that produces single value for one vector, say \code{mean} or \code{sum}.}

\item{sortValueDec}{Logical, sort decreasing.}

\item{addSum}{Logical, plot the overall trend.}

\item{paths}{Character or list or characters, name of paths to plot; if \code{NULL} plot all paths; see examples.}

\item{xlab}{Character, x-axis label.}

\item{ylab}{Character, y-axis label; can be a vector of several labels if there are more traits in \code{x} (recycled!).}

\item{xlim}{Numeric, a vector of two values with x-axis limits; use a list of vectors for more traits.}

\item{ylim}{Numeric, a vector of two values with y-axis limits; use a list of vectors for more traits.}

\item{ylimRel}{Numeric, a vector of two values with y-axis limits for relative values; use a list of vectors for more traits.}

\item{color}{Character, color names; by default a set of 54 colors is predefined from the \pkg{RColorBrewer} package;
in addition a black colour is attached at the begining for the overall trend; if there are more paths than
colors then recycling occours.}

\item{lineSize}{Numeric, line width.}

\item{lineType}{Numeric, line type (recycled); can be used only if lineTypeList=NULL.}

\item{lineTypeList}{List, named list of numeric values that help to point out a set of paths
(distinguished with line type) within upper level of paths (distinguished by,
color), e.g., lineTypeList=list("-1"=1, "-2"=2, def=1) will lead to use
of line type 1 for paths having "-1" at the end of path name and line type 2,
for paths having "-2" at the end of path name, while line type 1 (default) will,
be used for other paths; specification of this argument also causes recycling
of colors for the upper level of paths; if NULL all lines have a standard line type,
otherwise \code{lineType} does not have any effect.}

\item{useDirectLabels}{Logical, use directlabels package for legend.}

\item{method}{List, method for direct.label.}

\item{labelPath}{Character, legend title; used only if \code{useDirectLabels=FALSE}.}

\item{...}{Arguments passed to other functions (not used at the moment).}
}
\value{
A list of ggplot objects that can be further modified or displayed.
For each trait in \code{x} there are two plots (one for absolute values and one for
relative values).
}
\description{
A function to plot summary of partitioned additive genetic values.
}
\details{
Information in summaries of partitions of additive genetic values can be
overhelming due to a large volume of numbers. Plot method can be used to
visualise this data in eye pleasing way using ggplot2
graphics.
}
\examples{
\donttest{
## Load an example data
data("AlphaPart.ped")

## Partition additive genetic values by location
(res <- AlphaPart(x=AlphaPart.ped, colPath="loc", colAGV=c("agv1", "agv2")))

## Summarize population by generation (=trend)
(ret <- summary(res, by="gen"))

## Plot the partitions
p <- plot(ret, ylab=c("AGV for trait 1", "AGV for trait 2"), xlab="Generation")
print(p[[1]]$abs)
print(p[[1]]$rel)
print(p[[2]])
print(p)

## Partition additive genetic values by location and sex
AlphaPart.ped$loc.sex <- with(AlphaPart.ped, paste(loc, sex, sep="-"))
(res <- AlphaPart(x=AlphaPart.ped, colPath="loc.sex", colAGV=c("agv1", "agv2")))

## Summarize population by generation (=trend)
(ret <- summary(res, by="gen"))

## Plot the partitions
p <- plot(ret, ylab=c("AGV for trait 1", "AGV for trait 2"), xlab="Generation")
print(p)
p <- plot(ret, ylab=c("AGV for trait 1", "AGV for trait 2"), xlab="Generation",
        lineTypeList=list("-1"=1, "-2"=2, def=3))
print(p)
p <- plot(ret, ylab=c("AGV for trait 1", "AGV for trait 2"), xlab="Generation",
        lineTypeList=list("-1"=1, "-2"=2, def=3), useGgplot2=FALSE, useDirectLabels = FALSE)
print(p)

## Plot control (color and type of lines + limits)
p <- plot(ret, ylab=c("AGV for trait 1", "AGV for trait 2"), xlab="Generation",
        useGgplot2=TRUE, color=c("green", "gray"), lineType=c(2, 3),
        sortValue=FALSE, lineSize=4,
        xlim=c(-1, 7))
print(p)
}
}
