% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_join.R
\name{pat_join}
\alias{pat_join}
\title{Join PurpleAir time series data for a single sensor}
\usage{
pat_join(...)
}
\arguments{
\item{...}{Any number of valid PurpleAir Time series \emph{pat} objects.}
}
\value{
A PurpleAir Time series \emph{pat} object.
}
\description{
Create a merged timeseries using of any number of \emph{pat} 
objects for a single sensor. If \emph{pat} objects are non-contiguous, the 
resulting \emph{pat} will have gaps.
}
\note{
An error is generated if the incoming \emph{pat} objects have 
non-identical metadata.
}
\examples{
library(AirSensor)

aug01_08 <- 
  example_pat \%>\%
  pat_filterDate(20180801, 20180808)

aug15_22 <- 
  example_pat \%>\% 
  pat_filterDate(20180815, 20180822)
  
pat_join(aug01_08, aug15_22) \%>\%
  pat_multiPlot(plottype = "pm25")

}
