% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_getDistance.R
\name{monitor_getDistance}
\alias{monitor_getDistance}
\title{Calculate distances from \emph{mts_monitor} locations to a location of interest}
\usage{
monitor_getDistance(
  monitor = NULL,
  longitude = NULL,
  latitude = NULL,
  measure = c("geodesic", "haversine", "vincenty", "cheap")
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{longitude}{Longitude of the location of interest.}

\item{latitude}{Latitude of the location of interest.}

\item{measure}{One of "geodesic", "haversine" "vincenty", or "cheap".}
}
\value{
Named vector of distances (meters) with each distance identified
by \code{deviceDeploymentID}.
}
\description{
This function returns the distances (meters) between \code{monitor} locations
and a location of interest. These distances can be used to create a
mask identifying monitors within a certain radius of the location of interest.
}
\note{
The measure \code{"cheap"} may be used to speed things up depending on
the spatial scale being considered. Distances calculated with
\code{measure = "cheap"} will vary by a few meters compared with those
calculated using \code{measure = "geodesic"}.
}
\examples{
library(AirMonitor)

# Walla Walla
longitude <- -118.3302
latitude <- 46.065

distance <- monitor_getDistance(NW_Megafires, longitude, latitude)
closestIndex <- which(distance == min(distance))

# Distance in meters
distance[closestIndex]

# Monitor metadata
str(NW_Megafires$meta[closestIndex,])

}
