% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportToJson.R
\name{exportConditionToJson}
\alias{exportConditionToJson}
\title{exportConditionToJson}
\usage{
exportConditionToJson(
  connectionDetails,
  cdmDatabaseSchema,
  resultsDatabaseSchema,
  outputPath,
  vocabDatabaseSchema = cdmDatabaseSchema
)
}
\arguments{
\item{connectionDetails}{An R object of type ConnectionDetail (details for the function that
contains server info, database type, optionally username/password,
port)}

\item{cdmDatabaseSchema}{Name of the database schema that contains the vocabulary files}

\item{resultsDatabaseSchema}{Name of the database schema that contains the Achilles analysis
files. Default is cdmDatabaseSchema}

\item{outputPath}{folder location to save the JSON files. Default is current working
folder}

\item{vocabDatabaseSchema}{name of database schema that contains OMOP Vocabulary. Default is
cdmDatabaseSchema. On SQL Server, this should specifiy both the
database and the schema, so for example 'results.dbo'.}
}
\value{
none
}
\description{
\code{exportConditonToJson} Exports Achilles Condition report into a JSON form for reports.
}
\details{
Creates individual files for Condition report found in Achilles.Web
}
\examples{
\dontrun{
connectionDetails <- DatabaseConnector::createConnectionDetails(dbms = "sql server",
                                                                server = "yourserver")
exportConditionToJson(connectionDetails,
                      cdmDatabaseSchema = "cdm4_sim",
                      outputPath = "your/output/path")
}
}
