% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_colour_layer.R
\name{scale_colour_academic_c}
\alias{scale_colour_academic_c}
\title{Scale Plot Colours With Academic Themes (Continuous)}
\usage{
scale_colour_academic_c(palette_name, ...)
}
\arguments{
\item{palette_name}{The name of a colour palette in \code{AcademicThemes}.}

\item{...}{Arguments passed to \code{ggplot2::scale_colour_gradientn()}}
}
\value{
A layer that can be added to a ggplot2 object.
}
\description{
Scale Plot Colours With Academic Themes (Continuous)
}
\examples{
library(ggplot2)
ggplot(
  data.frame(
    x = runif(1500),
    y = runif(1500)
  ),
  aes(x = x, y = y, colour = x)
) +
  geom_point() +
  scale_colour_academic_c("cruk") +
  theme_classic() +
  labs(
    x = "X-Axis",
    y = "Y-Axis",
    colour = "Colour"
  )
}
