% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATA_Core.R
\name{ATA.Core}
\alias{ATA.Core}
\title{The core algorithm of the ATA Method}
\usage{
ATA.Core(X, pk, qk, phik, mdlType, initialLevel, initialTrend)
}
\arguments{
\item{X}{A numeric vector or time series.}

\item{pk}{Value of Level parameter.}

\item{qk}{Value of Trend parameter.}

\item{phik}{Value of Damping Trend parameter.}

\item{mdlType}{An one-character string identifying method using the framework terminology.}

\item{initialLevel}{"none" is default,
\itemize{
     \item{none}    : ATA Method calculates the pth observation in \code{X} for level.
     \item{mean}     : ATA Method calculates average of first p value in \code{X}for level.
     \item{median}: ATA Method calculates median of first p value in \code{X}for level.
}}

\item{initialTrend}{"none" is default,
\itemize{
     \item{none}    : ATA Method calculates the qth observation in \code{X} for trend.
     \item{mean}     : ATA Method calculates average of first q value in \code{X(T)-X(T-1)} for trend.
     \item{median}: ATA Method calculates median of first q value in \code{X(T)-X(T-1)} for trend.
}}
}
\value{
Returns an object of class "\code{ATA}"
}
\description{
The core algorithm of the ATA Method
}
