% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATA_Transform.R
\name{ATA.BackTransform}
\alias{ATA.BackTransform}
\title{Back Transformation Techniques for The ATAforecasting}
\usage{
ATA.BackTransform(X, tMethod, tLambda, tShift, tbiasadj = FALSE, tfvar = NULL)
}
\arguments{
\item{X}{a numeric vector or time series of class \code{ts} or \code{msts} for in-sample.}

\item{tMethod}{Box-Cox power transformation family is consist of "Box_Cox", "Sqrt", "Reciprocal", "Log", "NegLog",
"Modulus", "BickelDoksum", "Manly", "Dual", "YeoJohnson", "GPower", "GLog" in ATAforecasting package.}

\item{tLambda}{Box-Cox power transformation family parameter. If NULL, data transformed before model is estimated.}

\item{tShift}{Box-Cox power transformation family shifting parameter. If NULL, data transformed before model is estimated.}

\item{tbiasadj}{Use adjusted back-transformed mean for Box-Cox transformations using \code{forecast::BoxCox}. If transformed data is used to produce forecasts and fitted values,
a regular back transformation will result in median forecasts. If tbiasadj is TRUE, an adjustment will be made to produce mean forecasts and fitted values.}

\item{tfvar}{Optional parameter required if tbiasadj=TRUE. Can either be the forecast variance, or a list containing the interval \code{level}, and the
corresponding \code{upper} and \code{lower} intervals.}
}
\value{
A list object consists of transformation parameters and transformed data.
\code{ATA.Transform} is a list containing at least the following elements:
\itemize{
	 \item{trfmX}   : Transformed data
	 \item{tLambda} : Box-Cox power transformation family parameter
	 \item{tShift}  : Box-Cox power transformation family shifting parameter
}
}
\description{
The function provides the applicability of different types of back transformation techniques for the transformed data to which the Ata method will be applied.
The \code{ATA.BackTransform} function works with many different types of inputs.
}
\references{
#'\insertRef{tukey1957}{ATAforecasting}

#'\insertRef{boxcox1964}{ATAforecasting}

#'\insertRef{manly1976}{ATAforecasting}

#'\insertRef{johndraper1980}{ATAforecasting}

#'\insertRef{bickeldoksum1982}{ATAforecasting}

#'\insertRef{sakia1992}{ATAforecasting}

#'\insertRef{guerrero1993}{ATAforecasting}

#'\insertRef{yeojohn2000}{ATAforecasting}

#'\insertRef{glog2002}{ATAforecasting}

#'\insertRef{neglog2005}{ATAforecasting}

#'\insertRef{yang2006}{ATAforecasting}

#'\insertRef{gpower2013}{ATAforecasting}
}
\keyword{Ata}
\keyword{Bickel--Doksum}
\keyword{Box--Cox}
\keyword{Guerrero}
\keyword{Manly}
\keyword{Yeo--Johnson}
\keyword{dual}
\keyword{glog}
\keyword{gpower}
\keyword{neglog}
\keyword{transformation}
