% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsToAQuadtree.R
\name{pointsToAQuadtree}
\alias{pointsToAQuadtree}
\title{Add SpatialPoints to an AQuadtree obtject.}
\usage{
pointsToAQuadtree(qt, points)
}
\arguments{
\item{qt}{object of class "AQuadtree".}

\item{points}{object of class "SpatialPoints" or "SpatialPointsDataFrame".}
}
\value{
AQuadtree with the information of the given set of points aggregated
at each corresponding cell of the given AQuadtree.
}
\description{
Given an object of class AQuadtree and an object of class SpatialPoints or
SpatialPointsDataFrame for the same area, \code{pointsToAQuadtree}
returns a new object of class AQuadtree aggregating the data from the points
to the cells where each point fall.
}
\details{
The function \code{pointsToAQuadtree} returns a new AQuadtree object with
the input set of points aggregated to the input AQuadtree object. The function
creates a “p.total” attribute to compute the total
number of points aggregated to each cell of the input AQuadtree.
If points is an object of class SpatialPointsDataFrame, the function
summarises numeric attributes in the dataframe using the \code{mean}
function, and deploys factor attributes creating a new attribute for each label of the
factor to calculate the count. The attributes added to the resulting
AQuadtree object are prefixed with “p.”.
}
\examples{
data("BarcelonaPop")
Barcelona.QT<-AQuadtree(BarcelonaPop)
BcnWomen75yPop<-BarcelonaPop[BarcelonaPop$sex=='woman' & BarcelonaPop$age>=75, 'age']
Barcelona.extended.QT<-pointsToAQuadtree(Barcelona.QT, BcnWomen75yPop)

}
