% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_APCsummary.R
\name{create_APCsummary}
\alias{create_APCsummary}
\title{Create a summary table for multiple estimated GAM models}
\usage{
create_APCsummary(model_list, dat, digits = 2, apc_range = NULL, ...)
}
\arguments{
\item{model_list}{A list of regression models estimated with
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}. If the list is named, the
names are used as labels. Can also be a single model object instead of a list.}

\item{dat}{Dataset with columns \code{period} and \code{age}. If \code{y_var}
is specified, the dataset must contain the respective column. If \code{model}
is specified, the dataset must have been used for model estimation with
\code{gam} or \code{bam}.}

\item{digits}{Number of digits for numeric columns. Defaults to 2.}

\item{apc_range}{Optional list with one or multiple elements with names
\code{"age","period","cohort"} to filter the data. Each element should
contain a numeric vector of values for the respective variable that should
be kept in the data. All other values are deleted before producing the table.}

\item{...}{Optional additional arguments passed to \code{\link[knitr]{kable}}.}
}
\value{
Table created with \code{\link[knitr]{kable}}.
}
\description{
Create a table to summarize the overall effect strengths of the age, period
and cohort effects for models fitted with \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}. The output format can be adjusted by passing
arguments to \code{\link[knitr]{kable}} via the \code{...} argument.
}
\details{
If the model was estimated with a log or logit link, the function
automatically performs an exponential transformation of the effect.
}
\examples{
library(APCtools)
library(mgcv)

data(travel)

# create the summary table for one model
model_pure <- gam(mainTrip_distance ~ te(age, period), data = travel)
create_APCsummary(model_pure, dat = travel)

# create the summary table for multiple models
model_cov  <- gam(mainTrip_distance ~ te(age, period) + s(household_income),
                  data = travel)
model_list <- list("pure model"      = model_pure,
                   "covariate model" = model_cov)
create_APCsummary(model_list, dat = travel)

}
\author{
Alexander Bauer \email{alexander.bauer@stat.uni-muenchen.de}
}
