% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density_helpers.R
\name{calc_density}
\alias{calc_density}
\title{Internal helper to calculate the (group-specific) density of a variable}
\usage{
calc_density(dat, y_var, weights_var = NULL, ...)
}
\arguments{
\item{dat}{Dataset with columns \code{period} and \code{age} and the
main variable specified through argument \code{y_var}.}

\item{y_var}{Character name of the main variable to be plotted.}

\item{weights_var}{Optional character name of a weights variable used to
project the results in the sample to some population.}

\item{...}{Additional arguments passed to \code{\link[stats]{density}}.}
}
\value{
Dataset with the calculated densities.
}
\description{
Internal helper function that is called in \code{\link{plot_density}} to
calculate the density of a metric variable. If \code{plot_density} is called
from within \code{\link{plot_densityMatrix}} (i.e., when some of the columns
\code{c("age_group","period_group","cohort_group")} are part of the dataset,
the density is computed individually for all respective APC groups.
}
