% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.post.distribution2.R
\name{vis.post.distribution2}
\alias{vis.post.distribution2}
\title{Histogram of posterior distribution}
\usage{
vis.post.distribution2(
  x,
  quantile = c(0.05, 0.95),
  backgroud.color = "gray63",
  observe.value.color = "white",
  ci.lower.color = "white",
  ci.upper.color = "white",
  xlab = NULL,
  main = NULL,
  legend = TRUE,
  legend.position = "topright",
  record = TRUE
)
}
\arguments{
\item{x}{A numeric vector with the first value corresponding to the observed value.}

\item{quantile}{a numeric vector of length 2 to indicate the lower and upper confidence interval.}

\item{backgroud.color}{A specification for the default histogram background color.}

\item{observe.value.color}{A specification for the default abline line color of the observed value.}

\item{ci.lower.color}{A specification for the default abline line color of the lower confidence interval.}

\item{ci.upper.color}{A specification for the default abline line color of the lower confidence interval.}

\item{xlab}{A string for x axis label.}

\item{main}{A string for histogram main title.}

\item{legend}{A bolean to print or not the legend}

\item{legend.position}{The x co-ordinates to be used to position the legend. They can be specified by keyword or in any way which is accepted by xy.coords:}

\item{record}{A bolean indicating to return or not the histogram in a R object.}
}
\value{
an histogram of posterior distribution.
}
\description{
Create histogram of posterior distribution and compute posterior distribution statistics (p-values and confidence interval).
}
\examples{
t=met.strength(sim.m,sim.df,1) # Computing network metric
t=perm.net.nl(t,labels='age',rf=NULL,nperm=1000,progress=FALSE) # Node label permutations
r.c=stat.cor(t,'age','strength',progress=FALSE) # Permuted correlation test
vis.post.distribution(r.c[,1])# Histogram of posterior distribution
}
