% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{microorganisms.codes}
\alias{microorganisms.codes}
\title{Translation table for microorganism codes}
\format{A \code{\link{data.frame}} with 5,171 observations and 2 variables:
\describe{
  \item{\code{certe}}{Commonly used code of a microorganism}
  \item{\code{mo}}{ID of the microorganism in the \code{\link{microorganisms}} data set}
}}
\usage{
microorganisms.codes
}
\description{
A data set containing commonly used codes for microorganisms, from laboratory systems and WHONET. Define your own with \code{\link{set_mo_source}}.
}
\section{Catalogue of Life}{

\if{html}{\figure{logo_col.png}{options: height=40px style=margin-bottom:5px} \cr}
This package contains the complete taxonomic tree of almost all microorganisms (~60,000 species) from the authoritative and comprehensive Catalogue of Life (\url{http://www.catalogueoflife.org}). The Catalogue of Life is the most comprehensive and authoritative global index of species currently available.

\link[=catalogue_of_life]{Click here} for more information about the included taxa. The Catalogue of Life releases updates annually; check which version was included in this package with \code{\link{catalogue_of_life_version}()}.
}

\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\seealso{
\code{\link{as.mo}} \code{\link{microorganisms}}
}
\keyword{datasets}
