% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsi.R
\name{as.rsi}
\alias{as.rsi}
\alias{is.rsi}
\alias{is.rsi.eligible}
\title{Class 'rsi'}
\usage{
as.rsi(x)

is.rsi(x)

is.rsi.eligible(x)
}
\arguments{
\item{x}{vector}
}
\value{
Ordered factor with new class \code{rsi} and new attribute \code{package}
}
\description{
This transforms a vector to a new class \code{rsi}, which is an ordered factor with levels \code{S < I < R}. Invalid antimicrobial interpretations will be translated as \code{NA} with a warning.
}
\details{
The function \code{is.rsi.eligible} returns \code{TRUE} when a columns contains only valid antimicrobial interpretations (S and/or I and/or R), and \code{FALSE} otherwise.
}
\examples{
rsi_data <- as.rsi(c(rep("S", 474), rep("I", 36), rep("R", 370)))
rsi_data <- as.rsi(c(rep("S", 474), rep("I", 36), rep("R", 370), "A", "B", "C"))
is.rsi(rsi_data)

# this can also coerce combined MIC/RSI values:
as.rsi("<= 0.002; S") # will return S

plot(rsi_data)    # for percentages
barplot(rsi_data) # for frequencies
freq(rsi_data)    # frequency table with informative header

# fastest way to transform all columns with already valid AB results to class `rsi`:
library(dplyr)
septic_patients \%>\%
  mutate_if(is.rsi.eligible,
            as.rsi)
}
\seealso{
\code{\link{as.mic}}
}
\keyword{rsi}
