% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atc.R
\name{guess_atc}
\alias{guess_atc}
\title{Find ATC code based on antibiotic property}
\usage{
guess_atc(x)
}
\arguments{
\item{x}{character vector to determine \code{ATC} code}
}
\value{
Character (vector).
}
\description{
Use this function to determine the ATC code of one or more antibiotics. The dataset \code{\link{antibiotics}} will be searched for abbreviations, official names and trade names.
}
\details{
In the ATC classification system, the active substances are classified in a hierarchy with five different levels.  The system has fourteen main anatomical/pharmacological groups or 1st levels.  Each ATC main group is divided into 2nd levels which could be either pharmacological or therapeutic groups.  The 3rd and 4th levels are chemical, pharmacological or therapeutic subgroups and the 5th level is the chemical substance.  The 2nd, 3rd and 4th levels are often used to identify pharmacological subgroups when that is considered more appropriate than therapeutic or chemical subgroups.
  Source: \url{https://www.whocc.no/atc/structure_and_principles/}
}
\examples{
# These examples all return "J01FA01", the ATC code of Erythromycin:
guess_atc("J01FA01")
guess_atc("Erythromycin")
guess_atc("eryt")
guess_atc("ERYT")
guess_atc("ERY")
guess_atc("Erythrocin") # Trade name
guess_atc("Eryzole")    # Trade name
guess_atc("Pediamycin") # Trade name
}
\seealso{
\code{\link{antibiotics}} for the dataframe that is being used to determine ATC's.
}
