% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_models.R
\name{select_models}
\alias{select_models}
\title{Select models based on AICc and VIF.}
\usage{
select_models(df, delta_aicc = 2)
}
\arguments{
\item{df}{a data frame containing the models to select from.}

\item{delta_aicc}{a numeric value specifying the maximum difference in AICc values allowed.}
}
\value{
a data frame containing the selected models and the AIC weights.
}
\description{
This function selects models from a data frame based on the AICc and VIF values. Models with AICc greater than negative infinity and VIF less than or equal to 6 are considered. The difference in AICc values for each model is calculated with respect to the model with the minimum AICc. Models with a difference in AICc less than or equal to the specified delta_aicc value are selected.
}
\examples{
df <- data.frame(AICc = c(10, 12, 15, 20), max_vif = c(2, 4, 5, 6))
select_models(df)
select_models(df, delta_aicc = 5)
}
