\name{simIDS}
\alias{simIDS}
\encoding{UTF-8}

\title{
Simulate data for an integrated distance sampling, point count and occupancy study
}
\description{

Generates hierarchical distance sampling data, point count data, and occupancy (detection/nondetection) data for an integrated distance sampling (IDS) model with shared density and availability processes, but possibly different detection/perceptability processes (i.e., different detection functions).

The function calls \code{\link{simHDSpoint}} to generate hierarchical distance sampling (HDS) data under a point transect protocol with a half-normal detection function. Density is modeled as a log-linear regression on a "habitat" covariate, with coefficients \code{mean.density} and \code{beta.density}.

Point count and occupancy data are also generated by calls to \code{\link{simHDSpoint}}, assuming that the underlying detection process involves reduced probability of detection with distance from the observer. The distances from the observer are discarded, and only the counts (for PC data) or species detection information (for occupancy) retained.

Availability is modeled according to Sólymos et al. (2013), where the probability of availability depends on the duration of the observation.
}

\usage{
simIDS(mean.density = 1, beta.density = 1, mean.phi = 0.14, beta.phi = 0,
    nsites_HDS = 1000, sigHDS = 100, maxDist_HDS = 200, nbins = 4,
    range.dur.HDS = c(5, 5),
    nsites_PC = 10000, sigPC = 70, maxDist_PC = 500, range.dur.PC = c(3, 30),
    nsites_OC = 5000, sigOC = sigPC, maxDist_OC = maxDist_PC,
    range.dur.OC = range.dur.PC,
    show.plots = TRUE)
}
\arguments{
  \item{mean.density}{
the expected value of density (animals per hectare) when the habitat covariate = 0; the intercept of the log-linear regression for density is log(mean.density).
}
  \item{beta.density}{
the slope of the log-linear regression for density on a habitat covariate.
}
  \item{mean.phi}{
the expected value of the availability parameter.
}
  \item{beta.phi}{
the slope of the log-linear regression for availability on a covariate - not yet implemented.
}
  \item{nsites_HDS}{
the number of sites (point transects) for distance sampling.
}
  \item{sigHDS}{
the value of the scale parameter of the half-normal detection function for distance sampling.
}
  \item{maxDist_HDS}{
the truncation distance for distance sampling (in meters); any observations beyond this distance are discarded.
}
  \item{nbins}{
the number of distance bins for grouping distance sampling data.
}
  \item{range.dur.HDS}{
the range of durations for distance sampling; durations for each site are simulated from a uniform distribution with this range.
}
  \item{nsites_PC}{
the number of sites for point counts; set to 0 to suppress generation of point counts.
}
  \item{sigPC}{
the value of the scale parameter of the half-normal detection function for point counts.
}
  \item{maxDist_PC}{
the maximum distance from the observer for detection of animals when conducting point counts (m).
}
  \item{range.dur.PC}{
the range of durations for point counts; durations for each site are simulated from a uniform distribution with this range.
}

  \item{nsites_OC}{
the number of sites for occupancy surveys; set to 0 to suppress generation of occupancy data.
}
  \item{sigOC}{
the value of the scale parameter of the half-normal detection function for occupancy surveys.
}
  \item{maxDist_OC}{
the maximum distance from the observer for detection of animals when conducting occupancy surveys (m).
}
  \item{range.dur.OC}{
the range of durations for point counts; durations for each site are simulated from a uniform distribution with this range.
}
  \item{show.plots}{
choose whether to show plots or not. Set to FALSE when using function in simulations.
}
}

\value{
A list with the values of the arguments entered and the following additional elements:

\item{dds }{simulated durations for distance sampling: a vector length \code{nsites_HDS} with a value for each site}
\item{umf_hds0 }{an \code{unmarkedFrameDS} [package "unmarked"] with the simulated distance sampling data BEFORE allowing for availability}
\item{umf_hds1 }{an \code{unmarkedFrameDS} [package "unmarked"] with the simulated distance sampling data AFTER allowing for availability}
\item{dpc }{simulated durations for point counts: a vector length \code{nsites_PC} with a value for each site}
\item{umf_pc0 }{an \code{unmarkedFramePCount} [package "unmarked"] with the simulated point count data BEFORE allowing for availability}
\item{umf_pc1 }{an \code{unmarkedFramePCount} [package "unmarked"] with the simulated point count data AFTER allowing for availability}
\item{doc }{simulated durations for occupancy surveys: a vector length \code{nsites_OC} with a value for each site}
\item{umf_oc0 }{an \code{unmarkedFrameOccu} [package "unmarked"] with the simulated occupancy data BEFORE allowing for availability}
\item{umf_oc1 }{an \code{unmarkedFrameOccu} [package "unmarked"] with the simulated occupancy data AFTER allowing for availability}
}

\references{
Kéry, M. & Royle, J.A. (2016) \emph{Applied Hierarchical Modeling in Ecology} AHM1 - 8.5.1.

Sólymos, P. et al. (2013) Calibrating indices of avian density from non-standardized survey data: making the most of a messy situation. \emph{Methods in Ecology and Evolution} 4, 1047-1058.

Kéry, M. et al. (2022) Integrated distance sampling models for simple point counts. (Submitted to \emph{Ecology})
}

\note{
A function to analyze these data, \code{IDS}, will appear in a future version of \pkg{unmarked}. In the meantime, a devel version can be installed with \code{remotes::install_github("kenkellner/unmarked", ref="IDS")}.
}

\author{
Ken Kellner, Marc Kéry, Mike Meredith
}

\examples{
# Simulate a data set with the default arguments and look at the structure of the output
tmp <- simIDS()
str(tmp)
}
