% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/parse_packet_set_ACTIVITY2.R,
%   R/read_gt3x_bin_dev_type1.R, R/read_gt3x_bin_legacy_type1.R,
%   R/read_gt3x_parse_log_bin.R
\name{dev1_bin_initialize}
\alias{dev1_bin_initialize}
\alias{init_RAW}
\alias{dev_bin_type1}
\alias{legacy_bin_type1}
\alias{legacy_parse}
\alias{dev_parse}
\alias{parse_log_bin}
\title{Parse the log component of a gt3x file}
\usage{
dev1_bin_initialize(log, verbose, include)

init_RAW(info, tz)

dev_bin_type1(log, tz, verbose, include, info)

legacy_bin_type1(log, tz, verbose = FALSE, include, info)

legacy_parse(file, ...)

dev_parse(file, ...)

parse_log_bin(
  log,
  info,
  tz = "UTC",
  verbose = FALSE,
  include = .packets,
  parser,
  file
)
}
\arguments{
\item{log}{RawVector for internal use; the contents of \code{log.bin}}

\item{verbose}{logical. Print updates to console?}

\item{include}{character. The PACKET types to parse}

\item{info}{result of \code{\link{read_gt3x_info}}}

\item{tz}{character. The timezone to use}

\item{file}{internal list object containing information about the zip archive}

\item{...}{for internal use. Arguments passed to the specific parser from the
\code{parse_log_bin} shell}

\item{parser}{the parsing scheme to use, either \code{legacy}, \code{dev}, or
\code{external}. The legacy parser runs slowly but includes more extensive
checks to ensure alignment with \code{RAW.csv} and \code{IMU.csv} files.
The development parser runs faster and has also been checked for alignment
with \code{RAW.csv} and \code{IMU.csv} files, but not as strictly. For
example, rounding is not performed by \code{parser="dev"}. The external
parser is a wrapper for \code{read.gt3x::read.gt3x}, and specific arguments
can be passed in via \code{...}}
}
\description{
Parse the log component of a gt3x file
}
\keyword{internal}
