% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_gt3x.R
\name{collapse_gt3x}
\alias{collapse_gt3x}
\alias{collapse_gt3x.RAW}
\alias{collapse_gt3x.IMU}
\title{Collapse data that were read using \code{\link{read_gt3x}}}
\usage{
collapse_gt3x(
  AG,
  filename = "gt3x file",
  output_window_secs = 1,
  filter = TRUE,
  filter_hz = 35,
  verbose = FALSE,
  ...
)

\method{collapse_gt3x}{RAW}(
  AG,
  filename = "gt3x file",
  output_window_secs = 1,
  filter = TRUE,
  filter_hz = 35,
  verbose = FALSE,
  method = c("legacy", "expanded"),
  ...
)

\method{collapse_gt3x}{IMU}(
  AG,
  filename = "gt3x file",
  output_window_secs = 1,
  filter = TRUE,
  filter_hz = 35,
  verbose = FALSE,
  method = c("legacy", "expanded"),
  ...
)
}
\arguments{
\item{AG}{The object to collapse, inheriting from class "RAW" or "IMU"}

\item{filename}{character. Filename to associate with the data.}

\item{output_window_secs}{the desired epoch length; defaults to one second}

\item{filter}{a logical scalar: Apply a low-pass filter to gyroscope data?}

\item{filter_hz}{The cutoff for the low-pass filter}

\item{verbose}{A logical scalar: Print processing updates?}

\item{...}{Additional arguments. Currently unused.}

\item{method}{the collapsing method to use}
}
\value{
A data frame of collapsed data
}
\description{
Collapse data that were read using \code{\link{read_gt3x}}
}
\examples{
\donttest{
file <- system.file(
  "extdata",
  "example.gt3x",
  package = "AGread"
)
data <- read_gt3x(file)
head(collapse_gt3x(data$RAW))
head(collapse_gt3x(data$IMU))
}
}
