% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AG_insert.R
\name{AG_insert}
\alias{AG_insert}
\title{Calculate a new variable and insert it in a data frame}
\usage{
AG_insert(AG, var_name, after_var, value)
}
\arguments{
\item{AG}{The original data frame}

\item{var_name}{character. The new variable name}

\item{after_var}{character. The existing variable name, after which to insert
the new variable}

\item{value}{The value to assign the new variable}
}
\value{
A data frame with the new variable added at the specified index
}
\description{
Calculate a new variable and insert it in a data frame
}
\examples{

data("imu_to_collapse")
test <- imu_to_collapse[ ,1:3]
head(AG_insert(
  test, "new_variable",
  "Timestamp", "A new variable"
))
}
