% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_IMU.R
\name{read_AG_IMU}
\alias{read_AG_IMU}
\title{File reading function for IMU files}
\usage{
read_AG_IMU(file, output_window_secs = 1, verbose = FALSE, skip = 10,
  filter = TRUE, filter_hz = 35)
}
\arguments{
\item{file}{character scalar giving the path to the IMU file}

\item{output_window_secs}{the desired epoch length; defaults to one second}

\item{verbose}{A logical scalar: Print processing updates?}

\item{skip}{Header length: Number of rows to skip when reading the file}

\item{filter}{a logical scalar: Apply a low-pass filter to gyroscope data?}

\item{filter_hz}{The cutoff for the low-pass filter}
}
\value{
A dataframe giving processed IMU data in the specified epoch length
}
\description{
File reading function for IMU files
}
\examples{
imu_file <-
    system.file("extdata",
        "TestID_LeftWrist_IMU.csv",
        package = "AGread")

read_AG_IMU(imu_file)

}
