% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMImage.R
\docType{methods}
\name{AFMImage-class}
\alias{AFMImage-class}
\alias{AFMImage}
\alias{initialize,AFMImage-method}
\alias{AFMImage}
\title{AFM image class}
\usage{
AFMImage(data, samplesperline, lines, hscansize, vscansize, scansize,
  fullfilename)

\S4method{initialize}{AFMImage}(.Object, data, samplesperline, lines, hscansize,
  vscansize, scansize, fullfilename)

AFMImage(data, samplesperline, lines, hscansize, vscansize, scansize,
  fullfilename)
}
\arguments{
\item{data}{($x,$y,$h): a data.table storing the coordinates of the sample and the measured heights}

\item{samplesperline}{number of samples per line (e.g.: 512)}

\item{lines}{number of line (e.g.: 512)}

\item{hscansize}{horizontal size of scan usualy in nanometer (e.g.: hscansize=1000 for a scan size of 1000 nm)}

\item{vscansize}{vertical size of scan usualy in nanometer (e.g.: vscansize=1000 for a scan size of 1000 nm)}

\item{scansize}{if hscansize equals vscansize, scansize is the size of scan usualy in nanometer (e.g.: scansize=1000 for a scan size of 1000 nm)}

\item{fullfilename}{directory and filename on the disk (e.g.: /users/ubuntu/flatten-image.txt)}

\item{.Object}{an AFMImage object}
}
\description{
A S4 class to store and manipulate images from Atomic Force Microscopes.

Constructor method of AFMImage Class.

Wrapper function AFMImage
}
\section{Slots}{

\describe{
\item{\code{data}}{($x,$y,$h): a data.table storing the coordinates of the sample and the measured heights}

\item{\code{samplesperline}}{number of samples per line (e.g.: 512)}

\item{\code{lines}}{number of line (e.g.: 512)}

\item{\code{hscansize}}{horizontal size of scan usualy in nanometer (e.g.: hscansize=1000 for a scan size of 1000 nm)}

\item{\code{vscansize}}{vertical size of scan usualy in nanometer (e.g.: vscansize=1000 for a scan size of 1000 nm)}

\item{\code{scansize}}{if hscansize equals vscansize, scansize is the size of scan usualy in nanometer (e.g.: scansize=1000 for a scan size of 1000 nm)}

\item{\code{fullfilename}}{directory and filename on the disk (e.g.: /users/ubuntu/flatten-image.txt)}
}}

\examples{
library(AFM)
library(data.table)

# create a 128 pixels by 128 pixels AFM image
Lines=128
Samplesperline=128
fullfilename="RandomFakeAFMImage"
# the size of scan is 128 nm
ScanSize=128
# the heights is a normal distribution in nanometers
nm<-c(rnorm(128*128, mean=0, sd=1 )) 

scanby<-ScanSize/Samplesperline
endScan<-ScanSize*(1-1/Samplesperline)
RandomFakeAFMImage<-AFMImage(
     data = data.table(x = rep(seq(0,endScan, by= scanby), times = Lines),
                       y = rep(seq(0,endScan, by= scanby), each = Samplesperline), 
                       h = nm),
     samplesperline = Samplesperline, lines = Lines, 
     vscansize = ScanSize, hscansize = ScanSize, scansize = ScanSize, 
     fullfilename = fullfilename )
}
\author{
M.Beauvais
}
