% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_matrix_ops.R
\name{chol0}
\alias{chol0}
\title{Cholesky decomposition}
\usage{
chol0(x)
}
\arguments{
\item{x}{A numeric matrix.}
}
\description{
Cholesky decomposition
}
\details{
\code{chol0} is implemented as (t o chol o t) becauase the Cholesky decomposition
in R (\code{chol}) \enumerate{
  \item returns an upper-triangle matrix;
  \item uses only the upper half of the matrix when the matrix is real.
}
This does not match with the usual math notation of A = LL^T, where L is
a lower triangular matrix. (Note that the Cholesky-Banachiewicz algorithm
for example only uses the lower triangular part of A to compute L, so one
should expect d L / d A to look like something you get by differentiating
a lower triangular matrix w.r.t. a lower triangular matrix, i.e. the resulting
Jacobian matrix is also lower triangular.)

To convert the R version of chol to the usual math version of chol, we define
  \code{chol0 <- function(x) { t(chol(t(x))) }}
The first transpose ensures the output is lower-triangular, and the second
ensures the lower-triangular part of the input is used. Now, chol0 \enumerate{
  \item returns a lower-trianglar matrix
  \item uses only the lower half of the matrix when the matrix is real
}
and this is what we want.
(Additional note: finite-differencing with Cholesky is not too accurate
due to the many floating point operations involved.)
}
\note{
This function uses only the lower-triangular part of the input and returns a lower-triangular matrix.
}
