% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADtools.R
\docType{package}
\name{ADtools-package}
\alias{ADtools}
\alias{ADtools-package}
\title{ADtools: Automatic Differentiation}
\description{
Implements the forward-mode automatic differentiation for
    multivariate functions using the matrix-calculus notation from Magnus and
    Neudecker (2019) <doi:10.1002/9781119541219>. Two key features of the package
    are: (i) it incorporates various optimisation strategies to improve performance;
    this includes applying memoisation to cut down object construction time, using
    sparse matrix representation to speed up derivative calculation, and creating
    specialised matrix operations to reduce computation time; (ii) it supports
    differentiating random variates with respect to their parameters, targeting
    Markov chain Monte Carlo (MCMC) and general simulation-based applications.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/kcf-jackson/ADtools}
  \item Report bugs at \url{https://github.com/kcf-jackson/ADtools/issues}
}

}
\author{
\strong{Maintainer}: Chun Fung Kwok \email{kwokcf@unimelb.edu.au} (\href{https://orcid.org/0000-0002-0716-3879}{ORCID})

Authors:
\itemize{
  \item Dan Zhu \email{dan.zhu@monash.edu} (\href{https://orcid.org/0000-0003-1487-2232}{ORCID})
  \item Liana Jacobi \email{ljacobi@unimelb.edu.au} (\href{https://orcid.org/0000-0001-7210-0500}{ORCID})
}

}
\keyword{internal}
