% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{CVP_ADMMc}
\alias{CVP_ADMMc}
\title{CV (no folds) ADMM penalized precision matrix estimation (c++)}
\usage{
CVP_ADMMc(n, S_train, S_valid, lam, alpha, diagonal = FALSE, rho = 2,
  mu = 10, tau_inc = 2, tau_dec = 2, crit = "ADMM", tol_abs = 1e-04,
  tol_rel = 1e-04, maxit = 10000L, adjmaxit = 10000L,
  crit_cv = "loglik", start = "warm", trace = "progress")
}
\arguments{
\item{n}{sample size for X_valid (used to calculate crit_cv)}

\item{S_train}{pxp sample covariance matrix for training data (denominator n).}

\item{S_valid}{pxp sample covariance matrix for validation data (denominator n).}

\item{lam}{positive tuning parameters for elastic net penalty. If a vector of parameters is provided, they should be in increasing order.}

\item{alpha}{elastic net mixing parameter contained in [0, 1]. \code{0 = ridge, 1 = lasso}. If a vector of parameters is provided, they should be in increasing order.}

\item{diagonal}{option to penalize the diagonal elements of the estimated precision matrix (\eqn{\Omega}). Defaults to \code{FALSE}.}

\item{rho}{initial step size for ADMM algorithm.}

\item{mu}{factor for primal and residual norms in the ADMM algorithm. This will be used to adjust the step size \code{rho} after each iteration.}

\item{tau_inc}{factor in which to increase step size \code{rho}}

\item{tau_dec}{factor in which to decrease step size \code{rho}}

\item{crit}{criterion for convergence (\code{ADMM} or \code{loglik}). If \code{crit = loglik} then iterations will stop when the relative change in log-likelihood is less than \code{tol.abs}. Default is \code{ADMM} and follows the procedure outlined in Boyd, et al.}

\item{tol_abs}{absolute convergence tolerance. Defaults to 1e-4.}

\item{tol_rel}{relative convergence tolerance. Defaults to 1e-4.}

\item{maxit}{maximum number of iterations. Defaults to 1e4.}

\item{adjmaxit}{adjusted maximum number of iterations. During cross validation this option allows the user to adjust the maximum number of iterations after the first \code{lam} tuning parameter has converged (for each \code{alpha}). This option is intended to be paired with \code{warm} starts and allows for "one-step" estimators. Defaults to 1e4.}

\item{crit_cv}{cross validation criterion (\code{loglik}, \code{AIC}, or \code{BIC}). Defaults to \code{loglik}.}

\item{start}{specify \code{warm} or \code{cold} start for cross validation. Default is \code{warm}.}

\item{trace}{option to display progress of CV. Choose one of \code{progress} to print a progress bar, \code{print} to print completed tuning parameters, or \code{none}.}
}
\value{
cross validation errors (cv_crit)
}
\description{
Cross validation (no folds) function for ADMMsigma. This function is to be used with CVP_ADMM.
}
\keyword{internal}
