% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{compute_mh_p_eatq__ss__surg_mean}
\alias{compute_mh_p_eatq__ss__surg_mean}
\title{Compute "Early Adolescent Temperament Questionnaire [Parent] (Super scale -
Surgency: Combines surgency, fear (reverse coded), and shyness (reverse
coded) scales): Mean [Validation: No more than 0 missing or declined]"}
\usage{
compute_mh_p_eatq__ss__surg_mean(
  data,
  name = "mh_p_eatq__ss__surg_mean",
  combine = TRUE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{combine}{logical, append the new computed column to the end
of original tibble? Default is \code{TRUE}.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{mh_p_eatq__ss__surg_mean}
Early Adolescent Temperament Questionnaire [Parent] (Super scale -
Surgency: Combines surgency, fear (reverse coded), and shyness (reverse
coded) scales): Mean [Validation: No more than 0 missing or declined]
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_eatq__surg_mean}
\item \code{mh_p_eatq__fear_mean} (revert)
\item \code{mh_p_eatq__shy_mean} (revert)
}
\item \emph{Excluded values:} none
}
}
\details{
Surgency = Surgency, Fear (reverse scored), Shyness (reverse scored)

In the super scale calculation, no NA is allowed.
}
\examples{
\dontrun{
compute_mh_p_eatq__ss__surg_mean(data) |>
  select(
    any_of(c(
      "mh_p_eatq__ss__surg_mean"
    ))
  )
}

}
