% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relcorrections.R
\name{splitrel}
\alias{splitrel}
\alias{SpearmanBrown}
\alias{FlanaganRulon}
\alias{RajuCoefficient}
\title{Split Half-Based Reliability Coefficients}
\usage{
SpearmanBrown(
  corr,
  ntests = 2,
  fix.negative = c("none", "nullify", "bilateral")
)

FlanaganRulon(x1, x2, fix.negative = c("none", "nullify", "bilateral"))

RajuCoefficient(x1, x2, prop, fix.negative = c("none", "nullify", "bilateral"))
}
\arguments{
\item{corr}{To-be-corrected correlation coefficient}

\item{ntests}{An integer indicating how many times larger the full test is, for which the corrected correlation coefficient is being computed.
When \code{ntests=2}, the formula will compute what the correlation coefficient would be if the test were twice as long.}

\item{fix.negative}{Determines how to deal with a negative value. "nullify" sets it to zero,
"bilateral" applies the correction as if it were a positive number, and then sets it to negative.
"none" gives the raw value. It should be noted that negative values are not supposed to occur,
and there is no commonly accepted way to deal with them when they do occur.}

\item{x1}{scores from half 1}

\item{x2}{scores from half 2}

\item{prop}{Proportion of the first half to the complete sample}
}
\value{
Spearman-Brown-corrected correlation coefficient.
}
\description{
Split Half-Based Reliability Coefficients
}
\section{Functions}{
\itemize{
\item \code{SpearmanBrown()}: Perform a Spearman-Brown correction on the provided correlation score.

\item \code{FlanaganRulon()}: Compute the true reliability using the Flanagan-Rulon formula,
which takes into account inequal variances between split halves.

\item \code{RajuCoefficient()}: Compute split-half reliability using the Raju formula,
which takes into account unequal split-halves and variances.

}}
\examples{

SpearmanBrown(.5)
FlanaganRulon(a<-rnorm(50),rnorm(50)+a*.5,fix.negative="bilateral")
a<-rnorm(50)
b<-rnorm(50)+a*.5
RajuCoefficient(a,b,prop=.4,fix.negative="bilateral")
}
\seealso{
\link{covrel}
}
