% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AATtools.R
\name{SpearmanBrown}
\alias{SpearmanBrown}
\title{Spearman-Brown corrections for Correlation Coefficients}
\usage{
SpearmanBrown(
  corr,
  ntests = 2,
  fix.negative = c("nullify", "bilateral", "none")
)
}
\arguments{
\item{corr}{To-be-corrected correlation coefficient}

\item{ntests}{An integer indicating how many times larger the full test is, for which the corrected correlation coefficient is being computed.
When \code{ntests=2}, the formula will compute what the correlation coefficient would be if the test were twice as long.}

\item{fix.negative}{Determines how to deal with a negative value. "nullify" sets it to zero,
"bilateral" applies the correction as if it were a positive number, and then sets it to negative. "none" gives the raw value.}
}
\value{
Spearman-Brown-corrected correlation coefficient.
}
\description{
Perform a Spearman-Brown correction on the provided correlation score.
}
\details{
Correct a correlation coefficient for being based on only a subset of the data.
}
