\name{effects}
\title{Effects from Fitted Model}
\usage{
effects(object, \dots)
effects.lm(object, set.sign=FALSE, \dots)
}
\alias{effects}
\alias{effects.lm}
\alias{effects.glm}
\arguments{
 \item{object}{an \R object; typically, the result of a model fitting function
   such as \code{\link{lm}}.}
 \item{set.sign}{logical. If \code{TRUE}, the sign of the effects
   corresponding to coefficients in the model will be set to agree with the
   signs of the corresponding coefficients, otherwise the sign is
   arbitrary.}
 \item{\dots}{arguments passed to or from other methods.}
}
\description{
  Returns (orthogonal) effects from a fitted model, usually a linear
  model. This is a generic function, but currently only has a method for
  objects inheriting from class \code{"lm"}.
}
\details{
  For a linear model fitted by \code{\link{lm}} or \code{\link{aov}},
  the effects are the uncorrelated single-degree-of-freedom values
  obtained by projecting the data onto the successive orthogonal
  subspaces generated by the QR decomposition during the fitting
  process. The first \eqn{r} (the rank of the model) are associated with
  coefficients and the remainder span the space of residuals (but are
  not associated with particular residuals).
}
\value{
  A (named) numeric vector of the same length as
  \code{\link{residuals}}, or a matrix if there were multiple responses
  in the fitted model, in either case of class \code{"coef"}.

  The first \eqn{r} rows are labelled by the corresponding coefficients,
  and the remaining rows are unlabelled.  Note that in rank-deficient
  models the ``corresponding''
  coefficients will be in a different order if pivoting occurred.
}
\references{
  Chambers, J. M. and Hastie, T. J. (1992)
  \emph{Statistical Models in S.}
  Wadsworth \& Brooks/Cole.
}
\seealso{\code{\link{coef}}}
\examples{
y <- c(1:3,7,5)
x <- c(1:3,6:7)
( ee <- effects(lm(y ~ x)) )
c(round(ee - effects(lm(y+10 ~ I(x-3.8))),3))# just the first is different
}
\keyword{models}
\keyword{regression}
