\name{tempfile}
\alias{tempfile}
\alias{tempdir}
\title{Create Names for Temporary Files}
\description{
  \code{tempfile} returns a vector of character strings which can be used as
  names for temporary files in the directory given by \code{tempdir}.
}
\usage{
tempfile(pattern = "file")
tempdir()
}
\arguments{
  \item{pattern}{a non-empty character vector giving the initial part
    of the name.}
}
\value{
  For \code{tempfile} a character vector giving the names of possible
  (temporary) files. Note that no files are generated by
  \code{tempfile}.

  For \code{tempdir}, the path of the per-session temporary directory.
}
\details{
  If \code{pattern} has length greater than one then the result is of the
  same length giving a temporary file name for each component of
  \code{pattern}. 

  The names are very likely to be unique among calls to \code{tempfile}
  in an \R session and across simultaneous \R sessions.  The filenames are
  guaranteed not to be currently in use.

#ifdef unix
  The file name is made of the pattern, the process number in hex and a
  random suffix in hex. The filenames will be in the directory given by
  \code{tempdir()}.  This will be a subdirectory of the directory given
  \code{TMPDIR} if set, otherwise \code{"/tmp"}.
#endif
#ifdef windows
  The directory will be a subdirectory of the first found of
  the environment variables \code{TMP}, \code{TEMP} and \code{R\_USER}
  (see \code{\link{Rconsole}}). If the path to the directory contains
  a space in any of the components, the path returned will use the
  shortnames version of the path. 
#endif
}
\seealso{\code{\link{unlink}} for deleting files.}
#ifdef unix
\examples{
tempfile(c("ab", "a b c"))   # give file name with spaces in!
}
#endif
\keyword{file}
