% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zen_file.R
\name{zen_file}
\alias{zen_file}
\title{Access a Zenodo deposit file}
\usage{
zen_file(
  deposit_id,
  file_name,
  cache_type = NULL,
  cache_dir = NULL,
  clear_cache = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{deposit_id}{numeric. The Zenodo deposit id.}

\item{file_name}{character. If \code{NULL}, all files from the file list. If a file name is specified, only this file will be downloaded.}

\item{cache_type}{character. Use \code{temporary} to a session temporary folder, \code{persistent} for a persistent cache folder or \code{NULL} to use the environment default. Check the section Cache Type for more details.}

\item{cache_dir}{character. User specified cache directory for persistent cache type.}

\item{clear_cache}{logical. If the mirror already exists, clear its content.}

\item{quiet}{logical. Show download info and progress bar.}
}
\value{
a string with the mirror file path.
}
\description{
Get the local path to a Zenodo deposit file. It not cached in a mirror yet, it will download the file to a deposit mirror cache locally.
}
\section{Cache type}{


The Zenodo mirror will be cached locally on a system folder. This folder can be temporary, being cleared when the R session is ended, or persistent across sections and reboots.

If the \code{cache_type} argument is \code{NULL} (the default) the package will check first the environment variable \code{zendown_cache_type}. If set, the package will use its value. If not set, a temporary cache folder will be used as default.

You can set an environment variable with \code{usethis::edit_r_environ()} and write as bellow for a persistent cache storage.

\code{zendown_cache_type = "persistent"}

After saving the file, remember to restart the session. With this setting, the cache will be persistent and stored at the directory given by \code{tools::R_user_dir("zendown", which = "cache")}

You may also use a different folder for persistent storage by setting the \code{zendown_cache_dir} environment variable. For example:

\verb{zendown_cache_dir = C:\\my_cache\\}

If you set the \code{cache_type} argument directly as \code{temporary} or \code{persistent}, it will override the environment setting.
}

\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# https://zenodo.org/records/10959197
zen_file_path <- zen_file(10959197, "iris.rds")
print(zen_file_path)
file.exists(zen_file_path)
\dontshow{\}) # examplesIf}
}
