% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xwf.R
\name{xwf}
\alias{xwf}
\title{Compute XWFs}
\usage{
xwf(xx, t, n.i, psi, w = function(t, i) ifelse(left, min(1, (1 -
  F(xx[[i]](t)))/(1 - b)), min(1, F(xx[[i]](t))/b)), b = 0.5, F = NULL,
  t.min = NULL, t.max = NULL, t.range = NULL, rel.shift = 0.001,
  left = TRUE)
}
\arguments{
\item{xx}{List of function for which to compute the XWFs}

\item{t}{Matrix containing the times at which the functions xx were measured: Element (i,j) contains the time of the j-th measurement of the i-th function.}

\item{n.i}{Vector containing the number of measurements for each function. The first n.i[i] elements of the i-th row of t should not be NA.}

\item{psi}{Predefined local feature which is a function of a function (first argument) and a measurement time (second argument)}

\item{w}{Weighting function. The default is the one used in the original paper.}

\item{b}{Parameter of the weighting function. See original paper for details. Ignored if weighting function w is not the default.}

\item{F}{CDF of the values of the functions xx. Ignored if weighting function w is not the default.}

\item{t.min}{Vector with time of first measurement for each function. Computed from t if omitted but providing it saves computational cost.}

\item{t.max}{Analogous to t.min but now the time of the last measurement.}

\item{t.range}{Vector with differences between t.max and t.min. Can be supplied to avoid recomputation.}

\item{rel.shift}{Optional relative reduction of the integration range to avoid instabilities at the end of the integration ranges. Set to 0 if no such correction is desired.}

\item{left}{Boolean specifying whether the left (TRUE) or right (FALSE) extrema-weighted features should be computed: Left and right refer to the weighting function. Ignored if weighting function w is not the default.}
}
\value{
Vector containing the extrema-weighted features obtained by numerical integration for each of the functions.
}
\description{
Compute extrema-weighted features based on functions, predefined local features, and weighting functions
}
\examples{
xwf(
xx = list(function(t) t),
t = (1:10)/10,
n.i = 10,
psi = function(x, t) x(t),
b = .2,
F = function(x) x
)

}
