#' Create a predxhaz_list from predxhaz objects
#'
#' Convenience constructor to compare multiple prediction objects with
#' \code{plot()} using \code{plot.predxhaz_list()}.
#'
#' @param ... Named \code{predxhaz} objects, or a single named list of them.
#' @return An object of class \code{predxhaz_list}.
#' @export
pred_list <- function(...) {
  x <- list(...)

  # allow pred_list(list(mod1=px1, mod2=px2))
  if (length(x) == 1L && is.list(x[[1]]) && !inherits(x[[1]], "predxhaz_list")) {
    x <- x[[1]]
  }

  if (!is.list(x) || length(x) == 0L) stop("No predxhaz objects supplied.")
  if (is.null(names(x)) || any(names(x) == "")) names(x) <- paste0("model", seq_along(x))

  structure(
    list(
      items = setNames(lapply(names(x), function(nm) list(All = x[[nm]])), names(x)),
      model_names  = names(x),
      group_ids    = "All",
      group_labels = "All"
    ),
    class = "predxhaz_list"
  )
}
