% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeDecode.R
\name{xegaGeGeneMapFactory}
\alias{xegaGeGeneMapFactory}
\title{Configure the gene map function of a genetic algorithm for grammar evolution.}
\usage{
xegaGeGeneMapFactory(method = "Mod")
}
\arguments{
\item{method}{String specifying the GeneMap function.}
}
\value{
Gene map function for genes.
}
\description{
\code{xegaGeGeneMapFactory()} implements the selection
             of one of the GeneMap functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error), if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "Mod" returns \code{xegaGeGeneMapMod()}. (Default).
             \item "Bucket" returns \code{xegaGeGeneMapmLCM()}.
             }
}
\examples{
XGene<-xegaGeGeneMapFactory("Mod")
gene<-xegaGeInitGene(lFxegaGeGene)
XGene(gene$gene1, lFxegaGeGene)
}
\seealso{
Other Configuration: 
\code{\link{xegaGeDecodeGeneFactory}()},
\code{\link{xegaGePrecisionFactory}()}
}
\concept{Configuration}
