% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{treeInsert}
\alias{treeInsert}
\title{Inserts a subtree into a derivation tree at a \code{node}.}
\usage{
treeInsert(tree, subtree, node)
}
\arguments{
\item{tree}{Derivation tree.}

\item{subtree}{Subtree.}

\item{node}{Attributed node.}
}
\value{
A derivation tree.
}
\description{
\code{treeInsert()} inserts a \code{subtree} into 
             a \code{tree} at a \code{node}.
}
\details{
An attributed \code{node} is a list 
             whose element \code{node$Index} contains 
             an access function to the node. 
             The access function is represented as a string 
             which contains an executable R index expression.
             All what remains to be done, is 
             \itemize{
             \item to complete 
             the assignment statement and 
             \item to parse and evaluate the string.
             }
}
\examples{
g<-compileBNF(booleanGrammar())
t1<-randomDerivationTree(g$Start, g)
t2<-randomDerivationTree(g$Start, g)
t1anl<-treeANL(t1, g$ST)
n1<-chooseNode(t1anl$ANL)
t2<-randomDerivationTree(n1$ID, g)
tI1<-treeInsert(t1, t2, n1)
decodeCDT(tI1, g$ST)

}
\seealso{
Other Tree Operations: 
\code{\link{compatibleSubtrees}()},
\code{\link{treeExtract}()}
}
\concept{Tree Operations}
