% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{isNonTerminal}
\alias{isNonTerminal}
\title{Is the numeric identifier a non-terminal symbol?}
\usage{
isNonTerminal(Id, ST)
}
\arguments{
\item{Id}{A numeric identifier (integer).}

\item{ST}{A symbol table.}
}
\value{
\itemize{ 
   \item \code{TRUE} if the numeric identifier is a terminal symbol.
   \item \code{FALSE} if the numeric identifier is a non-terminal symbol.
   \item \code{NA} if the symbol does not exist.}
}
\description{
\code{isNonTerminal()} tests if the numeric identifier 
              is a non-terminal symbol.
}
\details{
\code{isNonTerminal()} is one of the most frequently used 
         functions of a grammar-based genetic programming algorithm.
         Careful coding pays off! 
         Do not index the symbol table as a matrix 
         (e.g. \code{ST[2,2]}), because this is really slow!
}
\examples{
g<-compileBNF(booleanGrammar())
isNonTerminal(1, g$ST)
isNonTerminal(2, g$ST)
isNonTerminal(5, g$ST)
isNonTerminal(12, g$ST)
isNonTerminal(15, g$ST)
identical(isNonTerminal(15, g$ST), NA)

}
\seealso{
Other Utility Functions: 
\code{\link{derive}()},
\code{\link{id2symb}()},
\code{\link{isTerminal}()},
\code{\link{rules}()},
\code{\link{symb2id}()}
}
\concept{Utility Functions}
