% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdcc_estimation.R
\name{cdcc_estimation}
\alias{cdcc_estimation}
\title{This function estimates the parameters(alpha,beta) and time-varying correlation matrices(Rt) of cDCC-GARCH model.}
\usage{
cdcc_estimation(ini.para = c(0.05, 0.93), ht, residuals, method = c("COV",
  "LS", "NLS"), ts = 1)
}
\arguments{
\item{ini.para}{initial cDCC-GARCH parameters(alpha,beta) of optimization}

\item{ht}{matrix of conditional variance vectors}

\item{residuals}{matrix of residual(de-mean) returns}

\item{method}{shrinkage method of unconditional correlation matrix(Cov:sample,LS:Linear Shrinkage,NLS:NonLinear Shrinkage)}

\item{ts}{ts how many time series are you taking(dufalut:1 latest value)}
}
\value{
time-varying correlations(Rt) and the result of estimation
}
\description{
This function estimates the parameters(alpha,beta) and time-varying correlation matrices(Rt) of cDCC-GARCH model.
}
\note{
Rt are vectorized values of the conditional correlation matrix(Rt) until time t(ts) for each row.
}
\examples{
  library(rugarch)
  library(xdcclarge)
  #load data
  data(us_stocks)
  n<-3
  Rtn<-log(us_stocks[-1,1:n]/us_stocks[-nrow(us_stocks),1:n])
  
  # Step 1:GARCH Parameter Estimation with rugarch
  spec = ugarchspec()
  mspec = multispec( replicate(spec, n = n) )
  fitlist = multifit(multispec = mspec, data = Rtn)
  ht<-sigma(fitlist)^2
  residuals<-residuals(fitlist)
  
  # Step 2:cDCC-GARCH Parameter Estimation with xdcclarge
  cDCC<-cdcc_estimation(ini.para=c(0.05,0.93) ,ht ,residuals)
  #Time varying correlation matrix Rt at time t
  (Rt<-matrix(cDCC$cdcc_Rt,n,n))

  \dontrun{
  #If you want Rt at time t-s,then
  s<-10
  cDCC<-cdcc_estimation(ini.para=c(0.05,0.93) ,ht ,residuals,ts = s)
  matrix(cDCC$cdcc_Rt[s,],n,n)
  }
  
}
