% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/banner.R
\name{style_banner}
\alias{style_banner}
\title{Style Banner}
\usage{
style_banner(
  text_color = NULL,
  background_color = NULL,
  padding_horizontal = NULL,
  padding_vertical = NULL,
  height = NULL,
  width = NULL,
  font_size = NULL,
  font_family = NULL,
  z_index = NULL,
  selector = ":root"
)
}
\arguments{
\item{text_color}{The color of text in the banners which may be overridden by
other styles, e.g. link color, etc. The default value inherits from the
primary text color of the slide.}

\item{background_color}{The color of the banner background. By default
the background is transparent.}

\item{padding_horizontal, padding_vertical}{The inner padding of the banner.
By default no padding is applied in the vertical direction, but \verb{2em} of
padding is applied horizontally. If anything, you probably only want to
change the value of \code{padding_horizontal}.}

\item{height}{The height of the banner in a valid CSS unit.}

\item{width}{The maximum width of each column in the banner. You can set the
width for all columns with a single valid CSS unit, or you may provide a
vector of CSS units, named \code{"left"}, \code{"center"}, or \code{"right"} or provided
in that order.}

\item{font_size, font_family}{The font size and family of the text in the
banner. The default font size is \verb{0.7em} and the default family inherits
from the primary text of the slide.}

\item{z_index}{The z-index of the banner. By default this value is 0 so that
all other content appears over the banner. To ensure the banner appears
\emph{above slide content}, you can set \code{z_index} to something greater than 0.}

\item{selector}{A CSS selector, e.g. \code{".inverse"}, where the styles set in
this call should be applied. Typically, you'll either set these styles for
all banners using the default \code{selector}, or you'll want to customize the
banner appearance for particular slide classes. Note that you can call
\code{style_banner()} as many times as you want in your slides, but you'll want
to change the \code{selector} for each call.}
}
\value{
Returns a \verb{<style>} tag with the banner styles for \code{selector} as
HTML via \code{\link[htmltools:HTML]{htmltools::HTML()}}.
}
\description{
Change the banner style properties for a specific selector. By default, the
changes apply to all banners, but by setting \code{selector} you can apply style
changes to the banners of specific slide styles. For example, to set the
styles for inverse slides, use \code{selector = ".inverse"}.
}
\examples{
style_banner(text_color = "red")
style_banner(text_color = "white", background_color = "red")

}
\seealso{
\code{\link[=use_banner]{use_banner()}}
}
