% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_x3p.R
\name{image.x3p}
\alias{image.x3p}
\title{Raster image of an x3p surface}
\usage{
\method{image}{x3p}(x, ...)
}
\arguments{
\item{x}{an x3p object}

\item{...}{parameters passed into image}
}
\description{
\code{image.x3p} expands the generic image method for x3p objects.
This image function creates a raster image to show the surface of an x3p file.
Due to some inconsistency in the mapping of the origin (0,0), (choice between top left or bottom left)  image functions from different packages will result in different images.
}
\examples{
logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
image(logo)
}
