% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corMutShift.R
\name{corMutShift}
\alias{corMutShift}
\title{Corrective Values For Random Sequences For Mutations}
\usage{
corMutShift(fi = NULL)
}
\arguments{
\item{fi}{(character) file (and path) to RData to read as corMutShift or corInDelShift. The file when opend must contain a numeric vector either called 'corMutShift' or 'corInDelShift'.}
}
\value{
This functions returns a numeric vector  (possible mass alterations for random drawing)
}
\description{
The protein sequence and composition of most proteomes cannot be well mimicked by pure random sequences.
Thus, random sequences (for comparing the quality of fitting) shhould be corrected accordingly, this vector provides help to do so.
This function loads corMutShift- or corInDelShift-values from RData. 
The vector contains possible mass alterations for random drawing either by mutating a given aminoacid (\code{}corMutShift),
or by making or in/del changes (\code{}corInDelShift). These values are based on simulations in the human proteome (from UniProt).
}
\examples{
corMutShift <- corMutShift()
str(corMutShift)

corInDelShift <- corInDelShift()
str(corInDelShift)
}
\seealso{
\code{\link{corInDelShift}}, \code{\link{randMassByStochastic}}
}
