% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeCols.R
\name{.summarizeCols}
\alias{.summarizeCols}
\title{Summarize columns of matrix (or data.frame) 'x' using apply (main)}
\usage{
.summarizeCols(
  x,
  me = "median",
  nEq = FALSE,
  vectAs1row = TRUE,
  supl = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{data.frame matrix of data to be summarized by comlumn}

\item{me}{(character, length=1) summarization method (eg 'min','max','mean','mean.trim','median','sd','CV', 'medianComplete' or 'meanComplete' etc, see \code{\link{summarizeCols}})}

\item{nEq}{(logical) if TRUE, add additional column indicating the number of equal lines for choice (only with min or max)}

\item{vectAs1row}{(logical) if TRUE will interprete non-matrix 'x' as matrix with 1 row (correct effect of automatic conversion when extracting 1 line)}

\item{supl}{(numeric) supplemental parameters for the various summarizing functions (currently used with 'me=mean.trim' to assign upper and lower trimming fraction, passed to )}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
vector with summary for each column (unless 'me=="summary"', in this case a matrix or list will be returned )
}
\description{
This function summarizes columns of matrix (or data.frame) 'x' using apply
In case of character entries the 'median' of sorted values will be returned
}
\examples{
m1 <- matrix(c(28,27,11,12,11,12), nrow=2, dimnames=list(1:2,c("y","x","ref")))
.summarizeCols(m1, me="median")
}
\seealso{
\code{\link{summarizeCols}},  \code{\link[base]{table}} \code{\link[base]{table}}
}
