% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comments.R
\name{comment_add}
\alias{comment_add}
\alias{comment_get}
\alias{comment_reset}
\alias{comment_print}
\title{Add annotations and comments for workflows}
\usage{
comment_add(x, id, ..., append = TRUE, collapse = "\\n")

comment_get(x, id)

comment_reset(x, id)

comment_print(x, id = NULL, ...)
}
\arguments{
\item{x}{A workflow set outputted by \code{\link[=workflow_set]{workflow_set()}} or \code{\link[=workflow_map]{workflow_map()}}.}

\item{id}{A single character string for a value in the \code{wflow_id} column. For
\code{comment_print()}, \code{id} can be a vector or \code{NULL} (and this indicates that
all comments are printed).}

\item{...}{One or more character strings.}

\item{append}{A logical value to determine if the new comment should be added
to the existing values.}

\item{collapse}{A character string that separates the comments.}
}
\value{
\code{comment_add()} and \code{comment_reset()} return an updated workflow set.
\code{comment_get()} returns a character string. \code{comment_print()} returns \code{NULL}
invisibly.
}
\description{
\code{comment_add()} can be used to log important information about the workflow or
its results as you work. Comments can be appended or removed.
}
\examples{
two_class_set

two_class_set |> comment_get("none_cart")

new_set <-
  two_class_set |>
  comment_add("none_cart", "What does 'cart' stand for\u2753") |>
  comment_add("none_cart", "Classification And Regression Trees.")

comment_print(new_set)

new_set |> comment_get("none_cart")

new_set |>
  comment_reset("none_cart") |>
  comment_get("none_cart")
}
