% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{skin}
\alias{skin}
\title{Dermatology dataset}
\format{
A data frame with 11 variables.

\code{INV}:  Investigator identification number (5,6,8,9,10,11)

\code{ID}:  Participant ID

\code{center}:  Treatment center

\code{center2}:  Treatment center that pools centers 3 and 4 due to small sample size

\code{TRT}:  1 = Test drug, 2 = Placebo

\code{STAGE}:  Initial stage of disease (3 = Fair, 4 = Poor, 5 = Exacerbation)

\code{R1}:  Response at Time 1; NA if missing

\code{R2}:  Response at Time 2; NA if missing

\code{R3}:  Response at Time 3; NA if missing

\code{Stage4}:  1 if Stage 4, 0 otherwise

\code{Stage5}:  1 if Stage 5, 0 otherwise
}
\usage{
skin
}
\description{
The dermatology dataset is derived from a randomized clinical trial that
compared a test treatment with a control for managing skin conditions
\insertCite{stanish_1978}{winr}. This trial enrolled 172 patients—88 in the
test group and 84 in the placebo group—across six clinics. These patients were
assessed at three follow-up visits, where the degree of improvement in their
skin condition was measured on a five-point scale: 1 for rapidly improving,
2 for slowly improving, 3 for stable, 4 for slowly worsening, and 5 for
rapidly worsening. Due to Clinic 9 enrolling only four patients, data from
Clinics 8 and 9 were combined, a decision supported by these clinics having
the smallest sample sizes in their strata. The primary baseline variable
recorded was the stage of disease at the start of the study, categorized as
3 for fair, 4 for poor, and 5 for exacerbation. This dataset also features
missing data at follow-up visits, progressively increasing from 2\% (3
missing observations) at the first visit to 9\% (16 missing) at the second,
and 17\% (30 missing) at the third visit.
}
\references{
{
   \insertAllCited{}
}
}
\keyword{datasets}
