% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_plot_sum.R, R/rpinpallEst_prog.R
\name{print.rpinpall}
\alias{print.rpinpall}
\alias{summary.rpinpall}
\alias{plot.rpinpall}
\alias{rpinpallEst}
\title{Fit Input Allocation Random Parameters Model}
\usage{
\method{print}{rpinpall}(x, error = FALSE, ...)

\method{summary}{rpinpall}(object, ...)

\method{plot}{rpinpall}(x, ...)

rpinpallEst(
  data,
  id_time,
  total_input,
  crop_acreage,
  crop_indvar = NULL,
  crop_rp_indvar = NULL,
  weight = NULL,
  distrib_method = c("lognormal", "normal", "censored-normal"),
  sim_method = c("map_imh", "mhrw", "marg_imh", "mhrw_imh", "nuts", "variat",
    "lapl_approx"),
  calib_method = c("cmode", "cmean", "rscd", "estim-sim"),
  saem_control = list(),
  par_init = list()
)
}
\arguments{
\item{x}{An object produced by the function \code{rpinpallEst}, to be displayed}

\item{error}{logical. If TRUE, residuals are considered in variable input prediction}

\item{\dots}{Other arguments}

\item{object}{An object produced by the function \code{rpinpallEst}, to be displayed}

\item{data}{name of the data frame or matrix containing all the variables
included in the model.}

\item{id_time}{first (individual) and second (time) level variables allowing
characterizing panel data.}

\item{total_input}{variable (name) containing the total input used  at farm
level per ha to be allocated to the different crops.}

\item{crop_acreage}{list of variables containing the acreage of the different crops.}

\item{crop_indvar}{optional list of vector of (time-varying) variables
specific to each crop used to control for observed (individual and/or temporal)
characteristics in the estimation process. Default=NULL.}

\item{crop_rp_indvar}{optional list of vector of (time-constant) variables
specific to each crop used to control for observed time-constant
characteristics in the estimation process. Default=NULL.}

\item{weight}{optional variable containing weights of individual sample farms.
Default=NULL (equal weight is given to each farm). Default=NULL.}

\item{distrib_method}{assumption on the distribution of input use
per crop (x_kit): "normal", "lognormal" or "censored-normal". Default="lognormal".}

\item{sim_method}{method used to draw the random parameters in the simulation
step of the SAEM algorithm in the estimation process: "map_imh" (independant
Metropolis Hasting with Laplace approximation as proposal distribution),
"marg_imh" (independant Metropolis Hasting with marginal distribution of
random pararameters as proposal distribution), "mhrw" (Metropolis Hasting Random Walk),
"mhrw_imh" (combined "imh" and "mhrw"), "nuts","variat" and"lapl_approx". Default= "map_imh".}

\item{calib_method}{method used: "cmode" (conditional mode),
"cmean" (conditional mean). Default="cmode".}

\item{saem_control}{list of options for the SAEM algorithm. See 'Details}

\item{par_init}{list of some parameters' initialization.}
}
\value{
Distribution of estimated crop input uses.

This function returns a list with the following components:
\itemize{
\item {\code{xit_pred}: matrix of predicted crop input used per ha.}
\item {\code{xit_pred_with_error}: matrix of predicted crop input used per ha.}
\item {\code{yit_predict}: vector of predicted totat input used.}
\item {\code{est_pop} list of results of estimation: estimated parameters.}
\item {\code{est_stde}list of  parameters standard errors.}
\item {\code{call}: a copy of the function call.}
\item {\code{opt}: a list of saem algorithm control parameters.}
\item {\code{conv_ind_cll}: vector of convergence indicator.}
\item {\code{data_list}: a list of individual data used for estimation.}
}
}
\description{
Designed to fit a random parameters input allocation
model proposed in Koutchade et al., (2024) \url{https://hal.science/hal-04318163}.
It provides crops input cost for each individual at each time and can account
for Weighted Panel Data.
}
\details{
An SAEM algorithm is used to perform the estimation of input uses per crop.
Different options can be specified by the user for this algorithm in the saem_control argument.
The saem_control argument is list that can supply any of the following component.
\itemize{
\item \code{nb_burn_saem}: Number of iterations of the burn-in phase where individual
parameters are sampled from their conditional distribution using
sim_method and the initial values for model parameters without update
these parameters. Default=20.
\item \code{nb_SA}: Number of iterations in the exploration phase where algorithm
explore parameters space without memory. The parameter that controls the
convergence of the algorithm is set to 1. Default=200.
\item \code{nb_smooth}: Number of iterations in the smoothing phase.Default=200 and
the parameter that controls the convergence of the algorithm is set to 0.85 by default.
\item \code{nb_RS}: Number of iterations where tempering approach is used
\item \code{tol}: Tolerance value for the convergence. Default 1.10-3.
\item \code{estim_rdraw}: Number of random draws using in the estimation process. Default=100
\item \code{calib_rdraw}: Number of random draws using in the calibration process. Default=100
\item \code{stde_rdraw}:  Number of random draws using for computation of estimation
standard errors. Default=100
\item \code{p_SA}: Parameter determining  step sizes in the Stochastic
Approximation (SA) step. Must be comprise between 0 and 1. Default=0.85
\item \code{doParallels}:  Logical.If TRUE a parallel processing is used when more
than 2 cores are available. Default=FALSE
\item \code{doTempering}: Logical. If TRUE the tempering approach proposed by
(Allassonnière and Chevallier, 2021) is used to avoid convergence to local
maxima. Default=TRUE
\item \code{doDiagEps}: = "2",
\item \code{showProgress}: Logical. If TRUE the evolution of the estimation process is
displayed graphically at the bottom of the screen. Default=TRUE
\item \code{showIterConvLL}: Logical. If TRUE iteration number and convergence value
are displayed during the estimation process. Default=FALSE
}
}
\section{Functions}{
\itemize{
\item \code{print(rpinpall)}: Displays the distribution of estimated crop input uses accounting for error by default

\item \code{summary(rpinpall)}: Displays a summary of estimated parameters

\item \code{plot(rpinpall)}: Plot the "global" convergence indicator

}}
\examples{
\donttest{
data(my_winputall_data)
mydata <- my_winputall_data
fit <- rpinpallEst(data = my_winputall_data,
                   id_time = c("id","year"),
                   total_input = "tx",
                   crop_acreage = c("s_crop1","s_crop2","s_crop3"),
                   distrib_method = "lognormal",
                   sim_method = "map_imh",
                   calib_method = "cmode",
                   saem_control = list(nb_SA = 10, nb_smooth = 10, estim_rdraw = 10))
print(fit)
plot(fit)
summary(fit)
head(fit$xit_pred)
}

}
\references{
Koutchade, O. P., Carpentier A. and Femenia F. (2024).
}
