% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_USGS.R
\name{ww_instantaneousUSGS}
\alias{ww_instantaneousUSGS}
\title{Instantaneous USGS}
\usage{
ww_instantaneousUSGS(
  procDV,
  sites = NULL,
  parameter_cd = NULL,
  options = wwOptions(),
  parallel = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{procDV}{A previously created \link[whitewater]{ww_dvUSGS} object.}

\item{sites}{A \code{vector} of USGS NWIS sites. \code{optional}}

\item{parameter_cd}{A USGS code parameter code, only if using \code{sites} argument.}

\item{options}{A \link[whitewater]{wwOptions} call.}

\item{parallel}{\code{logical} indicating whether to use future_map().}

\item{verbose}{\code{logical} for printing information. TRUE (default).}

\item{...}{arguments to pass on to \link[furrr]{future_map}.}
}
\value{
A \code{tibble} with instantaneous values.
}
\description{
This function generates Instantaneous NWIS data from
\url{https://waterservices.usgs.gov/}.
}
\note{
For performance reasons, with multi-site retrievals you may
retrieve data since October 1, 2007 only. If a previously created \link[whitewater]{ww_dvUSGS} object is not used then the user needs to
provide a \code{sites} vector. This will run \link[whitewater]{ww_dvUSGS} in the background.
}
\examples{
\dontrun{

library(whitewater)
yaak_river_dv <- ww_dvUSGS('12304500',
parameter_cd = '00060',
wy_month = 10)

yaak_river_iv <- ww_instantaneousUSGS(yaak_river_dv)

#change number of days

yaak_river_iv <- ww_instantaneousUSGS(yaak_river_dv,
                                options = wwOptions(period = 365))

# get by date range

yaak_river_wy <- ww_instantaneousUSGS(yaak_river_dv,
                                options = wwOptions(date_range = 'date_range',
                                                    dates = c('2022-03-01', '2022-05-11')))

# get most recent

yaak_river_wy <- ww_instantaneousUSGS(yaak_river_dv,
                                options = wwOptions(date_range = 'recent'))

#parallel

#get sites

huc17_sites <- dataRetrieval::whatNWISdata(huc = 17,
siteStatus = 'active',
service = 'dv',
parameterCd = '00060')

library(future)
#need to call future::plan()
plan(multisession(workers = availableCores()-1))

pnw_dv <- ww_dvUSGS(huc17_sites$site_no,
parameter_cd = '00060',
wy_month = 10,
parallel = TRUE)

pnw_iv <- ww_instantaneousUSGS(pnw_dv,
                    parallel = TRUE)
}

}
