% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/white_test.R
\name{white_test_boot}
\alias{white_test_boot}
\title{Bootstrapped version of the White's test (Jeong, J., Lee, K. (1999))}
\usage{
white_test_boot(model, bootstraps = 1000)
}
\arguments{
\item{model}{An object of class \code{\link[stats]{lm}}}

\item{bootstraps}{Number of bootstrap to be performed. If `bootstraps` is less than 10, it will automatically be set to 10.
At least 500 simulations are recommended. Default value is set to 1000.}
}
\value{
A list with class \code{white_test} containing:\tabular{ll}{
   \code{w_stat} \tab The value of the test statistic \cr
   \tab \cr
   \code{p_value} \tab The p-value of the test \cr
   \tab \cr
   \code{iters} \tab The number of bootstrap samples \cr
   \tab \cr
}
}
\description{
This is a versioned White's test based on a bootstrap procedure that can improve the performance of White’s test,
specially in small samples. It was proposed by Jeong, J., Lee, K. (1999) (see references for further details).
}
\details{
The bootstrapped error term is defined by:

\deqn{\widehat{u_i} = \sigma^2 * t_i^{*} (i = 1,...N)}

where \eqn{t_i^{*}} follows a distribution satisfying \eqn{E(t) = 0} and \eqn{var(t) = I}.

In particular, the selected distribution of \eqn{t} can be found at the bottom of page 196 at Handbook of Computational Econometrics (2009).
}
\examples{
# Define a dataframe with heteroscedasticity
n <- 100
y <- 1:n
sd <- runif(n, min = 0, max = 4)
error <- rnorm(n, 0, sd*y)
X <- y + error
df <- data.frame(y, X)
# OLS model
fit <- lm(y ~ X, data = df)
# White's test
white_test_boot(fit)

}
\references{
Jeong, J., & Lee, K. (1999). Bootstrapped White’s test for heteroskedasticity in regression models. Economics Letters, 63(3), 261-267.

White, H. (1980). A Heteroskedasticity-Consistent Covariance Matrix Estimator
and a Direct Test for Heteroskedasticity. Econometrica, 48(4), 817-838.

Wooldridge, Jeffrey M., 1960-. (2012). Introductory econometrics : a modern approach. Mason, Ohio :
South-Western Cengage Learning,
}
