% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gis_analysis.R
\name{wbt_idw_interpolation}
\alias{wbt_idw_interpolation}
\title{Idw interpolation}
\usage{
wbt_idw_interpolation(
  input,
  field,
  output,
  use_z = FALSE,
  weight = 2,
  radius = NULL,
  min_points = NULL,
  cell_size = NULL,
  base = NULL,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input vector Points file.}

\item{field}{Input field name in attribute table.}

\item{output}{Output raster file.}

\item{use_z}{Use z-coordinate instead of field?.}

\item{weight}{IDW weight value.}

\item{radius}{Search Radius in map units.}

\item{min_points}{Minimum number of points.}

\item{cell_size}{Optionally specified cell size of output raster. Not used when base raster is specified.}

\item{base}{Optionally specified input base raster file. Not used when a cell size is specified.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Interpolates vector points into a raster surface using an inverse-distance weighted scheme.
}
\keyword{GISAnalysis}
